'use strict';

angular.module('genisis').controller('createStudyApprovalCtrl', ['$scope',
  'studyApproval', '$rootScope', '$location', 'user', 'api',
  function ($scope, $studies, $rootScope, $location, $user, $api) {

    //create the study approval object
    $scope.study = {
      createdBy: $user.id(),
      associatedApprovals: []
      //collaborators: []
    };

    $scope.collaborators = [];

    //load a list of users they can add as collaborators
    $scope.allUsers = [{
      id: 'researcher1',
      firstName: 'Researcher',
      lastName: '1'
    }, {
      id: 'researcher2',
      firstName: 'Researcher',
      lastName: '2'
    }, {
      id: 'datamgr1',
      firstName: 'Data Manager',
      lastName: '1'
    }, {
      id: 'datamgr2',
      firstName: 'Data Manager',
      lastName: '2'
    }, {
      id: 'admin',
      firstName: 'Administrator34',
      lastName: ''
    }];

    /**
     * Set the selected user to add an association for
     * @param Object user data
     **/
    $scope.setSelected = function (user) {
      $scope.selectedUser = user;
      $scope.selectedUser.name = user.firstName + ' ' + user.lastName;
    };

    /**
     * Add a collaborator to the list
     * @param Object user data
     * @return boolean
     **/
    $scope.associate = function (user) {
      if ($scope.collaborators.indexOf(user) === -1) {
        $scope.collaborators.push(user);
        return true;
      }

      return false;
    };

    /**
     * Remove a collaborator from the list
     * @param Object user Object
     * @return boolean
     **/
    $scope.unassociate = function (user) {

      for (var i = 0; i < $scope.collaborators.length; i++) {
        if ($scope.collaborators[i].id === user.id) {
          return $scope.collaborators.splice(i, 1);
        }
      }

      return false;
    };

    /**
     * Creating a new study approval
     **/
    $scope.createStudyApproval = function (study) {

      //clear any existing error messages
      $rootScope.errors = [];

      //format and add the collaborators
      // for (var i = 0; i < $scope.collaborators.length; i++) {
      //   $scope.study.collaborators.push($scope.collaborators[i].id);
      // }

      if (!$studies.valid(study)) {
        return;
      }

      //try to create the study
      $api.create('studyApprovals', {
        data: $scope.study
      }).then(
        function (request) {

          //redirect them back to the study if it was created successfully
          if (request.success && request.response) {
            $location.path('/studyApprovals/' + request.response.id);
          } else if (request && request.message) {
            $rootScope.errors.push(request.message);
          } else {
            $rootScope.errors.push(
              'Create study approval API call failed.');
          }
        }
      );
    };
  }
]);